'
'  This program reads and outputs to the screen data from the UART
' registers.  The DOS command-line syntax is
'
'  UARTR port register
'
' where port is the hex base address of the COM port and register is the
' register number to read (0 - 7).  Actually, although the primary purpose
' of UARTR is to access COM ports, it can be used to read any computer
' port.  For this more general usage, just specify the port address and 0
' for the register.  (Similarly, you can access UART registers in this
' manner by adding the 0-based register number to the port address
' yourself before using UARTR.)
'
'  (UARTR isn't particularly useful to read data from ports which is
' dynamically changing.  It's mainly a diagnostic tool for making sure
' that more or less static data is being properly stored.)
'
'  Get command-line arguments.  If incomplete, display message giving
' usage syntax.
'
PRINT
CALL PARSE(COMMAND$," ",P$,R$)
R$=LTRIM$(R$)
IF R$<>"" THEN
'
'  Convert UART register, which is really just a relative port address,
' to an absolute port address.
'
PORT=VAL("&H"+P$)+VAL("&H"+R$)
'
'  Read port and output its contents to screen.
'
PRINT "REGISTER VALUE = ";INP(PORT)
ELSE
PRINT "USAGE SYNTAX:"
PRINT
PRINT "UARTR hex_base_address register"
END IF
END
'
'  This subroutine parses the string S$ into parts S1$ and S2$ based on
' the delimiting string DL$.
'
SUB PARSE(S$,DL$,S1$,S2$)
SI$=LTRIM$(RTRIM$(S$))
N=LEN(SI$)
S1$=SI$
S2$=""
IF N=0 THEN GOTO TERM
I=INSTR(SI$,DL$)
IF I=0 THEN GOTO TERM
S1$=MID$(SI$,1,I-1)
S2$=MID$(SI$,I+LEN(DL$),N-I-LEN(DL$)+1)
TERM:
END SUB
